#include <iostream>
#include <cmath>
#include <set>

#define sqr(a) ((a) * (a))
#define max(a, b) ((a) > (b) ? (a) : (b))


void printRes(const std::set<int> &set) {
    std::cout << set.size() << std::endl;
    for (auto it = set.begin(); it != set.end(); ++it) {
        if (it != set.begin()) std::cout << ' ';
        std::cout << *it + 1;
    }
}

int main(int argc, char *argv[]) {
    int count;
    std::cin >> count;

    std::set<int> setA;
    std::set<int> setB;
    std::set<int> setC;
    std::set<int> setD;

    std::pair<int, int> diffA;
    std::pair<int, int> diffB;
    std::pair<int, int> diffC;
    std::pair<int, int> diffD;

    for (int i = 0; i < count; i++) {
        int x, y;
        std::cin >> x >> y;
        if (x > 0 && y > 0) {
            setA.insert(i);
            diffA.first += x;
            diffA.second += y;
        } else if (x < 0 && y > 0) {
            setB.insert(i);
            diffB.first += x;
            diffB.second += y;
        } else if (x < 0 && y < 0) {
            setC.insert(i);
            diffC.first += x;
            diffC.second += y;
        } else if (x > 0 && y < 0) {
            setD.insert(i);
            diffD.first += x;
            diffD.second += y;
        }
    }

    float distA = sqrtf(sqr(diffA.first) + sqr(diffA.second));
    float distB = sqrtf(sqr(diffB.first) + sqr(diffB.second));
    float distC = sqrtf(sqr(diffC.first) + sqr(diffC.second));
    float distD = sqrtf(sqr(diffD.first) + sqr(diffD.second));

    float distUp = sqrtf(sqr(diffA.first + diffB.first) + sqr(diffA.second + diffB.second));
    float distLeft = sqrtf(sqr(diffB.first + diffC.first) + sqr(diffB.second + diffC.second));
    float distDown = sqrtf(sqr(diffC.first + diffD.first) + sqr(diffC.second + diffD.second));
    float distRight = sqrtf(sqr(diffD.first + diffA.first) + sqr(diffD.second + diffA.second));

    float distMax = max(max(max(max(distA, distB), distC), distD), max(distUp, max(distLeft, max(distDown, distRight))));

    if (distMax == distA) printRes(setA);
    else if (distMax == distB) printRes(setB);
    else if (distMax == distC) printRes(setC);
    else if (distMax == distD) printRes(setD);
    else if (distMax == distUp) {
        std::set<int> setUp = setA;
        setUp.merge(setB);
        printRes(setUp);
    }
    else if (distMax == distLeft) {
        std::set<int> setLeft = setB;
        setLeft.merge(setC);
        printRes(setLeft);
    }
    else if (distMax == distDown) {
        std::set<int> setDown = setC;
        setDown.merge(setD);
        printRes(setDown);
    }
    else if (distMax == distRight) {
        std::set<int> setRight = setD;
        setRight.merge(setA);
        printRes(setRight);
    }
}